/*
 * Decompiled with CFR 0.152.
 */
package cf.garconia.jonsstuff;

import cf.garconia.jonsstuff.commands.FarmTime;
import cf.garconia.jonsstuff.commands.FeedCommand;
import cf.garconia.jonsstuff.commands.GiveWand;
import cf.garconia.jonsstuff.commands.HealCommand;
import cf.garconia.jonsstuff.commands.Reload;
import cf.garconia.jonsstuff.events.Events;
import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class JonsStuff
extends JavaPlugin
implements Listener {
    private static JonsStuff instance;
    private File customConfigFile;
    private File customConfigFeed;
    private File customConfigUsers;
    private FileConfiguration customConfig;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.createCustomConfig();
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getCommand("heal").setExecutor((CommandExecutor)new HealCommand());
        this.getCommand("rld").setExecutor((CommandExecutor)new Reload());
        this.getCommand("feed").setExecutor((CommandExecutor)new FeedCommand());
        this.getCommand("givewand").setExecutor((CommandExecutor)new GiveWand());
        this.getCommand("farmtime").setExecutor((CommandExecutor)new FarmTime());
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[Jons-Stuff] Plugin Is Enabled!");
    }

    public FileConfiguration getCustomConfig() {
        return this.customConfig;
    }

    private void createCustomConfig() {
        this.customConfigFile = new File(this.getDataFolder(), "Logs/Feed.yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            this.saveResource("Logs/Feed.yml", false);
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[Jons-Stuff] Plugin Is Disabled!");
    }

    public static JonsStuff getInstance() {
        return instance;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getConfig().getBoolean("youAreAwesome")) {
            player.sendMessage("You are awesome!");
            this.getServer().getConsoleSender().sendMessage(ChatColor.LIGHT_PURPLE + "[Jons-Stuff] Awsome!");
        } else {
            player.sendMessage("You are not awesome...");
        }
    }
}

